## 3f: Lower housing demand
## Probability of entry into homeownership falls by 5 per cent each year in first 5 years and then stays stable. 
## Housing entry prices grow 2 per cent slower than base scenario each year in first 5 years and then 0.5 per cent slower 
## each year thereafter. Housing returns fall from 7 to 5 per cent within 5 years.


# Prelims -----------------------------------------------------------------

gc()


# Starting cohort data ----------------------------------------------------

## starting cohort pathways (from step 3)
starting_cohorts_pathways <- qread(starting_cohorts_pathways_file)


# Adjust for scenario -----------------------------------------------------

## Reduce probability of entry by 5% each year within 5 years and then stays stable
home_transition_prob_adj <- starting_cohorts_pathways %>% 
  distinct(age_grp, year, total_inc_qtile, beqrec, home_trans_prob) %>% 
  mutate(home_trans_prob_adj = ifelse(year<=5, home_trans_prob*(0.95)^(year), home_trans_prob*0.95^5)) %>% 
  arrange(total_inc_qtile, age_grp, year)


## Reduce value of housing when purchased by 2% each year within 5 years and then 0.5% less thereafter
new_housing_value_adj <- starting_cohorts_pathways %>% 
  distinct(year, total_inc_qtile, new_housing_val_param) %>% 
  mutate(new_housing_val_param_adj = ifelse(year<=5, new_housing_val_param*(0.98)^(year), new_housing_val_param*0.98^5 *0.995^(year-5)) )


## and housing returns are 5% within 5 years rather than 7%
housing_return_adj <-  starting_cohorts_pathways %>%  
  distinct(year, housing_asset_return_param) %>% 
  mutate(housing_asset_return_param_adj = ifelse(year %in% c(1:5), 
                                             0.07-(0.07-0.05)/5*(year-1),
                                             0.05)) 


# Put into new version of starting_cohorts, convert to year list and save --------

starting_cohorts_pathways_adj <- starting_cohorts_pathways %>% 
  left_join(home_transition_prob_adj) %>% 
  left_join(new_housing_value_adj) %>% 
  left_join(housing_return_adj) %>% 
  ## replace values
  select( -home_trans_prob, home_trans_prob = home_trans_prob_adj,
          -new_housing_val_param, new_housing_val_param = new_housing_val_param_adj,
          -housing_asset_return_param, housing_asset_return_param = housing_asset_return_param_adj) %>% 
  ## adjust housing asset saving accordingly
  mutate(housing_asset_saving_param = ifelse(housing_asset_saving_param>0,
                                             ## reduce value of new purchases by degree of difference between this scenario and base scenario returns
                                             housing_asset_saving_param*housing_asset_return_param/0.07,
                                             housing_asset_saving_param)
  )


## split into list by year - save for use in model running
year_list_0 <- starting_cohorts_pathways_adj %>% 
  split(., .$year) 

qsave(year_list_0, "./Output data/year_list_0_lower_housing_demand.qs")
